/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl.persist;

import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.persist.PersistableRequestBody;
import com.ibm.hwmca.fw.rbf.impl.persist.RbfRequestPersistence;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class RequestPersistencePMImpl
implements RbfRequestPersistence {
    private static final String TRACE_MASKT = "XRBFRPIT";
    private static final String TRACE_MASKF = "XRBFRPIF";
    private static final String TRACE_MASKD = "XRBFRPID";
    private static PersistenceManager persistMgr = PersistenceManager.getPersistenceManager();
    private static final String GRANDPARENT = "com.ibm.hwmca.fw.rbf";
    private static final String CHILD_REQUEST = "request";
    private static final String CHILD_REQUEST_BODY = "requestbody";

    public void storeRequest(RbfRequest request, boolean storeBody) throws RbfException {
        RbfRequestId requestId;
        block4: {
            requestId = request.getIdentifier();
            Trace.trace(TRACE_MASKT, "-> storeRequest() " + requestId);
            try {
                String parent = this.getParent(requestId);
                String requestChild = "com.ibm.hwmca.fw.rbf." + parent + "." + CHILD_REQUEST;
                String reqBodyChild = "com.ibm.hwmca.fw.rbf." + parent + "." + CHILD_REQUEST_BODY;
                persistMgr.write(requestChild, request);
                if (!storeBody) break block4;
                try {
                    PersistableRequestBody body = new PersistableRequestBody(request);
                    persistMgr.write(reqBodyChild, body);
                }
                catch (Exception e2) {
                    throw new RbfException(e2);
                }
            }
            catch (Exception e) {
                throw new RbfException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- storeRequest() " + requestId);
    }

    public void storeRequests(List requests, boolean storeBodies) throws RbfException {
        Trace.trace(TRACE_MASKT, "-> storeRequests() " + requests.size());
        ListIterator iterator = requests.listIterator();
        while (iterator.hasNext()) {
            this.storeRequest((RbfRequest)iterator.next(), storeBodies);
        }
        Trace.trace(TRACE_MASKT, "<- storeRequests()");
    }

    public RbfRequest loadRequest(RbfRequestId requestId) throws RbfException {
        Trace.trace(TRACE_MASKT, "-> loadRequest() " + requestId);
        String parent = "com.ibm.hwmca.fw.rbf." + this.removeChar(requestId.getUUID().toString(), '-');
        Trace.trace(TRACE_MASKT, "<- loadRequest() " + requestId);
        return this.loadRequest(parent);
    }

    public List loadRequests() throws RbfException {
        Trace.trace(TRACE_MASKT, "-> loadRequests()");
        ArrayList<RbfRequest> requests = new ArrayList<RbfRequest>();
        try {
            List parentNames = persistMgr.readParentNames(GRANDPARENT);
            Iterator parents = parentNames.iterator();
            while (parents.hasNext()) {
                String parent = (String)parents.next();
                try {
                    RbfRequest request = this.loadRequest(parent);
                    if (request == null) continue;
                    requests.add(request);
                }
                catch (RbfException rbfe) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new RbfException(e);
        }
        Trace.trace(TRACE_MASKT, "<- loadRequests() " + requests.size());
        return requests;
    }

    private RbfRequest loadRequest(String parent) throws RbfException {
        String requestChild = parent + "." + CHILD_REQUEST;
        String reqBodyChild = parent + "." + CHILD_REQUEST_BODY;
        RbfRequest request = null;
        try {
            request = (RbfRequest)persistMgr.read(requestChild);
            if (request != null) {
                PersistableRequestBody persistableBody = (PersistableRequestBody)persistMgr.read(reqBodyChild);
                if (persistableBody != null) {
                    request.setBody(persistableBody.getBody());
                }
            } else {
                persistMgr.delete(reqBodyChild);
                if (!persistMgr.hasChildren(parent)) {
                    persistMgr.delete(parent);
                }
            }
        }
        catch (Exception e) {
            throw new RbfException(e);
        }
        return request;
    }

    public void removeRequest(RbfRequest request) {
        RbfRequestId requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "-> removeRequest() " + requestId);
        String parent = this.getParent(requestId);
        String requestChild = "com.ibm.hwmca.fw.rbf." + parent + "." + CHILD_REQUEST;
        String reqBodyChild = "com.ibm.hwmca.fw.rbf." + parent + "." + CHILD_REQUEST_BODY;
        persistMgr.delete(requestChild);
        persistMgr.delete(reqBodyChild);
        if (!persistMgr.hasChildren("com.ibm.hwmca.fw.rbf." + parent)) {
            persistMgr.delete("com.ibm.hwmca.fw.rbf." + parent);
        }
        Trace.trace(TRACE_MASKT, "<- removeRequest() " + requestId);
    }

    public void removeRequests(List requests) {
        Trace.trace(TRACE_MASKT, "-> removeRequests() " + requests.size());
        ListIterator iterator = requests.listIterator();
        while (iterator.hasNext()) {
            this.removeRequest((RbfRequest)iterator.next());
        }
        Trace.trace(TRACE_MASKT, "<- removeRequests()");
    }

    private String getParent(RbfRequestId requestId) {
        return this.removeChar(requestId.getUUID().toString(), '-');
    }

    private String removeChar(String text, char theChar) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) != theChar) {
                sb.append(text.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

